<?php

// =============================================================================
// VIEWS/ADMIN/OPTIONS-PAGE.PHP
// -----------------------------------------------------------------------------
// Plugin options page.
// =============================================================================

// =============================================================================
// TABLE OF CONTENTS
// -----------------------------------------------------------------------------
//   01. Permissions Check
//   02. Require Options
//   03. Options Page Output
// =============================================================================

// Permissions Check
// =============================================================================

if ( ! current_user_can( 'manage_options' ) ) {
  wp_die( 'You do not have sufficient permissions to access this page.' );
}



// Require Options
// =============================================================================

require( TCO_FACEBOOK_COMMENTS_PATH . '/functions/options.php' );



// Options Page Output
// =============================================================================

?>

<div class="wrap tco-plugin tco-facebook-comments">
  <h2><?php _e( 'Facebook Comments', '__tco__' ); ?></h2>
  <div id="poststuff">
    <div id="post-body" class="metabox-holder columns-2">
      <form name="tco_facebook_comments_form" method="post" action="">
        <input name="tco_facebook_comments_form_submitted" type="hidden" value="submitted">
        <?php wp_nonce_field('tco_facebook_comments','tco_facebook_comments_noncename'); ?>
        <?php require( 'options-page-main.php' ); ?>
        <?php require( 'options-page-sidebar.php' ); ?>

      </form>
    </div>
    <br class="clear">
  </div>
</div>
