<?php

class StockholmCoreElementorAnimatedIconsWithText extends \Elementor\Widget_Base{
	public function get_name() {
		return 'animated_icon_with_text';
	}
	
	public function get_title() {
		return esc_html__( 'Animated Icon With Text', 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-animated-icons-with-text';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'columns',
			[
				'label' => esc_html__( 'Columns', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'two_columns'   => esc_html__('Two', 'stockholm-core'),
					'three_columns' => esc_html__('Three', 'stockholm-core'),
					'four_columns'  => esc_html__('Four', 'stockholm-core'),
					'five_columns'  => esc_html__('Five', 'stockholm-core'),
				],
				'default' => 'three_columns'
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$repeater->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_title_tag(false),
				'default' => 'h5'
			]
		);
		
		$repeater->add_control(
			'text',
			[
				'label' => esc_html__( "Text", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA
			]
		);
		
		stockholm_qode_icon_collections()->getElementorParamsArray($repeater, '', '', true);
		
		$repeater->add_control(
			'size',
			[
				'label' => esc_html__( "Icon Size", 'stockholm-core'),
				"description" => esc_html__( "Put number in px, ex.25", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$repeater->add_control(
			'icon_color',
			[
				'label' => esc_html__( "Icon Color", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$repeater->add_control(
			'icon_background_color',
			[
				'label' => esc_html__( "Icon background Color", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$repeater->add_control(
			'border_color',
			[
				'label' => esc_html__( "Border Color", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$repeater->add_control(
			'icon_color_hover',
			[
				'label' => esc_html__( "Icon Color on hover", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$repeater->add_control(
			'icon_background_color_hover',
			[
				'label' => esc_html__( "Icon Background Color On Hover", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$repeater->add_control(
			'border_color_hover',
			[
				'label' => esc_html__( "Border Color On Hover", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'animated_icons',
			[
				'label' => esc_html__( 'Animated Icons With Text', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => esc_html__('Animated Icons With Text'),
			]
		);
		
		$this->end_controls_section();
		
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();
		
		?>
		
		<div class="animated_icons_with_text clearfix <?php echo esc_attr( $params['columns'] ); ?>">
			<?php
				foreach ($params['animated_icons'] as $animated_icon){
					echo stockholm_qode_get_shortcode_template_part('templates/animated-icon-with-text', '_animated-icons-with-text', '', $animated_icon);
				}
			?>
		</div>
		
		<?php
	}
}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorAnimatedIconsWithText() );