<?php

class StockholmCoreElementorButton extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qbutton';
    }

    public function get_title() {
        return esc_html__( 'Button', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-button';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'size',
            [
                'label' => esc_html__( "Size", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Default', 'stockholm-core' ),
                    'small' => esc_html__( 'Small', 'stockholm-core' ),
                    'medium' => esc_html__( 'Medium', 'stockholm-core' ),
                    'large' => esc_html__( 'Large', 'stockholm-core' ),
                    'big_large' => esc_html__( 'Extra Large', 'stockholm-core' ),
                    'big_large_full_width' => esc_html__( 'Extra Large Full Width', 'stockholm-core' ),
                ],
                'default' => ''
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( "Style", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
	                ''              => esc_html__( 'Default', 'stockholm-core' ),
	                'white'         => esc_html__( 'White', 'stockholm-core' ),
	                'underlined'    => esc_html__( 'Underlined', 'stockholm-core' )
                ),
                'default' => ''
            ]
        );
	
	    $this->add_control(
		    'custom_class',
		    [
			    'label' => esc_html__('Custom CSS class', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
        
        $this->add_control(
            'text',
            [
                'label' => esc_html__( "Text", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( "Icon Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
	
	    $this->add_control(
		    'icon_size',
		    [
			    'label' => esc_html__( "Icon Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( "Link", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'target',
            [
                'label' => esc_html__( "Link Target", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_link_target_array(),
                'default' => '_self'
            ]
        );
        
        $this->add_control(
            'color',
            [
                'label' => esc_html__( "Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'hover_color',
            [
                'label' => esc_html__( "Hover Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__( "Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'hover_background_color',
            [
                'label' => esc_html__( "Hover Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => esc_html__( 'Border Color', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'hover_border_color',
            [
                'label' => esc_html__( 'Hover Border Color', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'design_options',
            [
                'label' => esc_html__( 'Design Options', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'font_size',
            [
                'label' => esc_html__('Font Size (px)', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
	
	    $this->add_control(
		    'font_style',
		    [
			    'label' => esc_html__( 'Font Style', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_font_style_array( true ),
			    'default' => ''
		    ]
	    );
	
	    $this->add_control(
		    'font_weight',
		    [
			    'label' => esc_html__( 'Font Weight', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_font_weight_array( true ),
			    'default' => ''
		    ]
	    );

		$this->add_control(
			'letter_spacing',
			[
				'label' => esc_html__('Letter Spacing (px)', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
	
	    $this->add_control(
		    'margin',
		    [
			    'label' => esc_html__( 'Margin', 'stockholm-core' ),
			    "description" => esc_html__("Please insert margin in format: 0px 0px 1px 0px", 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		
		    ]
	    );
	
	    $this->add_control(
		    'border_radius',
		    [
			    'label' => esc_html__( 'Border radius', 'stockholm-core' ),
			    "description" => esc_html__("Please insert border radius(Rounded corners) in px. For example: 4 ", 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		
		    ]
	    );
	    
	    $this->add_control(
		    'hover_animation',
		    [
			    'label' => esc_html__( 'Hover Animation', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''             => '',
				    'move_icon'    => esc_html__( 'Move Icon', 'stockholm-core' ),
				    'display_dash' => esc_html__( 'Dispaly Dash', 'stockholm-core' )
			    ],
			    'default' => ''
		    ]
	    );

        $this->end_controls_section();

        // Add predefined developer tab content for each shortcode element
        $this->start_controls_section(
            'developer_tools',
            [
                'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode_snippet',
            [
                'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'no',
                'options' => stockholm_qode_get_yes_no_select_array()
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	    $params['html_type'] = 'anchor';
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );

        if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
            echo $this->get_shortcode_snippet( $params );
        } else{
            echo stockholm_qode_get_shortcode_template_part('templates/button', '_button', '', $params);
        }
    }

    private function get_shortcode_snippet( $params ) {
        $atts = array();

        if ( empty( $this ) || ! is_object( $this ) ) {
            return '';
        }

        if ( ! empty( $params ) ) {
            foreach ( $params as $key => $value ) {
                if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
                    continue;
                }

                if( empty( $value ) || $value == '' ){
                    continue;
                }

                $atts[] = $key . '="' . esc_attr( $value ) . '"';
            }
        }

        return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
            'qbutton',
            implode( ' ', $atts )
        );
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorButton() );