<?php

class StockholmCoreElementorImageHover extends \Elementor\Widget_Base{
    public function get_name() {
        return 'image_hover';
    }

    public function get_title() {
        return esc_html__( "Image Hover", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-image-hover';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__( "Image", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA
            ]
        );

        $this->add_control(
            'hover_image',
            [
                'label' => esc_html__( "Hover Image", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( "Link", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'target',
            [
                'label' => esc_html__( "Target", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_link_target_array(),
                'default' => '_self'
            ]
        );
	
	    //had to be named stockholm_animation instead of animation because of the conflict with elementor animation field
        $this->add_control(
            'stockholm_animation',
            [
                'label' => esc_html__( "Animation", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false, false),
                'default' => 'no'
            ]
        );

        $this->add_control(
            'animation_speed',
            [
                'label' => esc_html__( "Animation Speed (in s)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'animation' => 'yes'
                ]
            ]
        );
	
	    $this->add_control(
		    'transition_delay',
		    [
			    'label' => esc_html__( "Transition Delay(s)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'animation' => 'yes'
			    ]
		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        if( ! empty( $params['image'] ) ){
            $params['image'] = $params['image']['id'];
        }

        if( ! empty( $params['hover_image'] ) ){
            $params['hover_image'] = $params['hover_image']['id'];
        }
	
	    //revert stockholm_animation to animation for template
	    if( ! empty( $params['stockholm_animation'] ) ){
		    $params['animation'] = $params['stockholm_animation'];
	    }
	
	    echo stockholm_qode_get_shortcode_template_part('templates/image-hover', '_image-hover', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorImageHover() );