<?php

class StockholmCoreElementorImageSlider extends \Elementor\Widget_Base{
    public function get_name() {
        return 'image_slider';
    }

    public function get_title() {
        return esc_html__( "Select Image Slider", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-image-slider';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'images',
            [
                'label' => esc_html__( "Images", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::GALLERY
            ]
        );

        $this->add_control(
            'on_click',
            [
                'label' => esc_html__( "On Click", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Do Nothing', 'stockholm-core' ),
                    'prettyphoto' => esc_html__( 'Open Image in Prettyphoto', 'stockholm-core' ),
                    'new_tab' => esc_html__( 'Open Image in New Tab', 'stockholm-core' ),
                    'use_custom_links' => esc_html__( 'Use Custom Links', 'stockholm-core' ),
                ],
                'default' => ''
            ]
        );

        $this->add_control(
            'custom_links',
            [
                'label' => esc_html__( "Custom Links", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                "description" => esc_html__( "Enter links for each image here. Divide links with comma.", 'stockholm-core' ),
                'condition' => [
                    'on_click' => 'use_custom_links'
                ]
            ]
        );
	
	    $this->add_control(
		    'custom_links_target',
		    [
			    'label' => esc_html__( "Custom Links Target", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_link_target_array( true ),
			    'default' => '',
			    'condition' => [
				    'on_click' => 'use_custom_links'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'link_all_items',
		    [
			    'label' => esc_html__( "Link all Items", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true),
			    'default' => '',
			    'condition' => [
				    'on_click' => 'use_custom_links'
			    ]
		    ]
	    );
	    
        $this->add_control(
            'height',
            [
                'label' => esc_html__( "Slider Height (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'navigation_style',
            [
                'label' => esc_html__( "Navigation Style", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => '',
                    'light' => esc_html__( 'Light', 'stockholm-core' ),
                    'dark' => esc_html__( 'Dark', 'stockholm-core' ),
                ],
                'default' => ''
            ]
        );

        $this->add_control(
            'highlight_active_image',
            [
                'label' => esc_html__( "Highlight Active Image", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(true, false),
                'default' => ''
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        $images_array = array();

        foreach ( $params['images'] as $image ){
            $images_array[] = $image['id'];
        }

        $params['images'] = implode(',', $images_array);

        echo stockholm_qode_get_shortcode_template_part('templates/image-slider', '_image-slider', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorImageSlider() );