<?php

class StockholmCoreElementorMessage extends \Elementor\Widget_Base{
    public function get_name() {
        return 'message';
    }

    public function get_title() {
        return esc_html__( "Message", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-message';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'type',
            [
                'label' => esc_html__( "Type", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'normal'    => esc_html__( 'Normal', 'stockholm-core' ),
                    'with_icon' => esc_html__( 'With Icon', 'stockholm-core' ),
                ],
                'default' => 'normal'
            ]
        );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);

        $this->add_control(
            'icon_size',
            [
                'label' => esc_html__( "Icon Size", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'fa-lg' => esc_html__( 'Small', 'stockholm-core' ),
                    'fa-2x' => esc_html__( 'Medium', 'stockholm-core' ),
                    'fa-3x' => esc_html__( 'Large', 'stockholm-core' ),
                ],
                'default' => 'fa-lg',
                'condition' => [
                    'icon_pack' => 'font_awesome'
                ]
            ]
        );
	
	    $this->add_control(
		    'icon_custom_size',
		    [
			    'label' => esc_html__( "Custom Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'type' => 'with_icon'
			    ]
		    ]
	    );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( "Icon Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'type' => 'with_icon'
                ]
            ]
        );

        $this->add_control(
            'icon_background_color',
            [
                'label' => esc_html__( "Icon Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'type' => 'with_icon'
                ]
            ]
        );

        $this->add_control(
            'custom_icon',
            [
                'label' => esc_html__( "Custom Icon", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'type' => 'with_icon'
                ]
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__( "Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
	
	    $this->add_control(
		    'border_color',
		    [
			    'label' => esc_html__( "Border Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	    
        $this->add_control(
            'border_width',
            [
                'label' => esc_html__( "Border Width (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__( "Default value is 2", 'stockholm-core' )
            ]
        );
        
        $this->add_control(
            'close_button_color',
            [
                'label' => esc_html__( "Close Button Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                "description" => esc_html__( "Default color is #fff", 'stockholm-core' )
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( "Content", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => "<p>".esc_html__( 'This is custom text content for shortcode element', 'stockholm-core' )."</p>"
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );
        $params['is_elementor'] = true;

        if( ! empty($params['custom_icon']) ){
            $params['custom_icon'] = $params['custom_icon']['id'];
        }

        echo stockholm_qode_get_shortcode_template_part('templates/message', '_message', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorMessage() );