<?php

if(function_exists("is_woocommerce")) {

    class StockholmCoreElementorProductList extends \Elementor\Widget_Base
    {
        public function get_name()
        {
            return 'qode_product_list';
        }

        public function get_title()
        {
            return esc_html__("Select Product List", 'stockholm-core');
        }

        public function get_icon()
        {
            return 'stockholm-elementor-custom-icon stockholm-elementor-product-list';
        }

        public function get_categories()
        {
            return ['select'];
        }

        protected function register_controls()
        {

            $this->start_controls_section(
                'general',
                [
                    'label' => esc_html__('General', 'stockholm-core'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );
	
	        $this->add_control(
		        'type',
		        [
			        'label' => esc_html__("Type", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::SELECT,
			        'options' => [
				        'standard' => esc_html__('Standard', 'stockholm-core'),
				        'simple'   => esc_html__('Simple', 'stockholm-core')
			        ],
			        'default' => 'standard'
		        ]
	        );
	
	        $this->add_control(
		        'columns',
		        [
			        'label' => esc_html__("Columns", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::SELECT,
			        'options' => [
				        "2" => esc_html__('Two', 'stockholm-core'),
				        "3" => esc_html__('Three', 'stockholm-core'),
				        "4" => esc_html__('Four', 'stockholm-core'),
				        "5" => esc_html__('Five', 'stockholm-core'),
			        ],
			        'default' => '3'
		        ]
	        );
	        
            $this->add_control(
                'items_number',
                [
                    'label' => esc_html__("Number of Items", 'stockholm-core'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => '12',
                    'description' => esc_html__( 'Leave empty for all.', 'stockholm-core' )
                ]
            );
            
            $this->add_control(
                'order_by',
                [
                    'label' => esc_html__("Order By", 'stockholm-core'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        "id"         => esc_html__('ID', 'stockholm-core'),
                        "date"       => esc_html__('Date', 'stockholm-core'),
                        "menu_order" => esc_html__('Menu Order', 'stockholm-core'),
                        "title"      => esc_html__('Title', 'stockholm-core'),
                    ],
                    'default' => 'date'
                ]
            );

            $this->add_control(
                'sort_order',
                [
                    'label' => esc_html__("Sort Order", 'stockholm-core'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => stockholm_qode_get_query_order_array(),
                    'default' => 'ASC'
                ]
            );
	
	        $this->add_control(
		        'taxonomy_to_display',
		        [
			        'label' => esc_html__("Choose Sorting Taxonomy", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::SELECT,
			        'options' => [
				        "category"  => esc_html__('Category', 'stockholm-core'),
				        "tag"       => esc_html__('Tag', 'stockholm-core'),
				        "id"        => esc_html__('Id', 'stockholm-core')
			        ],
			        'default' => 'category',
			        'description' => esc_html__( 'If you would like to display only certain products, this is where you can select the criteria by which you would like to choose which products to display.', 'stockholm-core' )
		        ]
	        );
	
	        $this->add_control(
		        'taxonomy_values',
		        [
			        'label' => esc_html__("Enter Taxonomy Values", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::TEXT,
			        'description' => esc_html__( 'Separate values (category slugs, tags, or post IDs) with a comma', 'stockholm-core' )
		        ]
	        );
	        
            $this->add_control(
                'display_categories',
                [
                    'label' => esc_html__("Display Categories", 'stockholm-core'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => stockholm_qode_get_yes_no_select_array(false),
                    'condition' => [
	                    'type' => 'standard'
                    ]
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $params = $this->get_settings_for_display();
	
	        if($params['type'] == 'standard') {
		        do_action('stockholm_qode_action_pl_standard_initial_setup', $params);
	        }
	        else if($params['type'] == 'simple') {
		        do_action('stockholm_qode_action_pl_simple_initial_setup');
	        }

            echo stockholm_qode_get_shortcode_template_part('templates/product-list', '_product-list', '', $params);
        }

    }

    \Elementor\Plugin::instance()->widgets_manager->register(new StockholmCoreElementorProductList());
}