<?php

class StockholmCoreElementorUnorderedList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'unordered_list';
    }

    public function get_title() {
        return esc_html__( 'Unordered List', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-unordered-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

	    $this->add_control(
		    'style',
		    [
			    'label' => esc_html__( 'Style', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'circle'    => esc_html__( 'Circle', 'stockholm-core' ),
				    'number'    => esc_html__( 'Number', 'stockholm-core' )
			    ),
			    'default' => 'circle'
		    ]
	    );

	    $this->add_control(
		    'number_type',
		    [
			    'label' => esc_html__( 'Number Type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'circle_number'         => esc_html__( 'Circle', 'stockholm-core' ),
				    'transparent_number'    => esc_html__( 'Transparent', 'stockholm-core' )
			    ),
			    'default' => 'circle_number',
			    'condition' => [
				    'style' => 'number'
			    ]
		    ]
	    );

	    $this->add_control(
		    'animate',
		    [
			    'label' => esc_html__( 'Animate List', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false),
			    'default' => 'no'
		    ]
	    );

	    $this->add_control(
		    'font_weight',
		    [
			    'label' => esc_html__( 'Font Weight', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    ''          => esc_html__( 'Default', 'stockholm-core' ),
				    'light'     => esc_html__( 'Light', 'stockholm-core' ),
				    'normal'    => esc_html__( 'Normal', 'stockholm-core' ),
				    'bold'      => esc_html__( 'Bold', 'stockholm-core' )
			    )
		    ]
	    );

	    $this->add_control(
		    'content',
		    [
			    'label' => esc_html__( "Content", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::WYSIWYG,
			    'default' => '<ul><li>' . esc_html__( 'Lorem Ipsum', 'stockholm-core' ) . '</li><li>' . esc_html__( 'Lorem Ipsum', 'stockholm-core' ) . '</li><li>' . esc_html__( 'Lorem Ipsum', 'stockholm-core' ) . '</li></ul>'

		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/unordered-list', '_unordered-list', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorUnorderedList() );