<div id="qodef-horizontal-layout" class="qodef--hidden">
	<div class="qodef-hl-items-wrapper">
		<?php if (!empty($intro_title) || !empty($intro_button_link)) { ?>
			<div class="qodef-hl-intro <?php echo esc_attr( $item_classes ); ?>">
				<div class="qodef-hl-intro-inner">
					<?php if( !empty($intro_title) ) { ?>
						<h1 class="qodef-hl-intro-title" <?php echo esc_attr( $animation_data ); ?>><?php echo esc_html( $intro_title ); ?></h1>
					<?php } ?>
					<?php if( !empty($intro_button_link) ) { ?>
						<?php $intro_button_text = ! empty( $intro_button_text ) ? $intro_button_text : esc_html__('See projects', 'stockholm-core'); ?>
						<a class="qodef-hl-intro-button qbutton" href="<?php echo esc_url( $intro_button_link ); ?>" target="_blank"><?php echo esc_html( $intro_button_text ) ?></a>
					<?php } ?>
				</div>
			</div>
		<?php } ?>

		<?php if (!empty($items)) : foreach ( $items as $key => $item ) : ?>
			<?php $type = 'image'; ?>
			<div class="qodef-hl-item" data-type="<?php echo esc_attr($type); ?>">
				<div class="qodef-hli-grid">
					<div class="qodef-hli-top">
					</div>
					<div class="qodef-hli-btm">
						<div class="qodef-hli-btm-inner">

							<?php if ($type == 'image') : ?>
								<?php if ( isset( $is_elementor ) && $is_elementor ) {
									$item['image'] = $item['image']['id'];
								} ?>
								<div class="qodef-hli-btm-item qodef-hli-image <?php echo esc_attr( $item_classes ); ?>">
									<div class="qodef-hli-btm-bg-image">
										<div class="qodef-hli-btm-bg-image-inner">
											<img src="<?php echo wp_get_attachment_url($item['image']); ?>" alt="<?php the_title($item['image']); ?>"/>
										</div>
									</div>
									<div class="qodef-hli-responsive-title-holder">
										<h2 class="qodef-hli-title" <?php echo esc_attr( $animation_data ); ?>>
											<?php if (!empty($item['link'])) { ?> <a href="<?php echo esc_url($item['link']); ?>" target="<?php echo esc_attr($item['target']); ?>"> <?php } ?>
												<?php echo esc_html($item['title']); ?>
												<?php if (!empty($item['link'])) { ?> </a> <?php } ?>
										</h2>
									</div>
									<?php
									if ( isset( $item['image_small_1'] ) && ! empty( $item['image_small_1'] ) ) {
										if( isset( $is_elementor ) && $is_elementor ) {
											$item['image_small_1'] = $item['image_small_1']['id'];
										} ?>
										<?php if( ! empty( $item['image_small_1_link'] ) ) { ?> <a href="<?php echo esc_url( $item['image_small_1_link'] ); ?>"> <?php } ?>
											<img class="qodef-hli-btm-img-1 <?php echo esc_attr( $item_classes ); ?>" src="<?php echo wp_get_attachment_url($item['image_small_1']); ?>" alt="<?php the_title($item['image_small_1']); ?>"/>
										<?php if( ! empty( $item['image_small_1_link'] ) ) { ?> </a> <?php } ?>
									<?php } ?>
									<?php
									/*image_small_1 is required because video size is calculated based on it*/
									if ( ! empty( $item['image_small_1'] ) && isset( $item['image_small_2'] ) && ! empty( $item['image_small_2'] ) ) {
										if( isset( $is_elementor ) && $is_elementor ) {
											$item['image_small_2'] = $item['image_small_2']['id'];
										} ?>
										<div class="qodef-hli-btm-img-2 qodef-m-video <?php echo esc_attr( $item_classes ); ?>">
											<?php if( ! empty( $item['image_small_2_link'] ) ) { ?> <a href="<?php echo esc_url( $item['image_small_2_link'] ); ?>"> <?php } ?>
											<img class="qodef-hli-btm-img-2 <?php echo esc_attr( $item_classes ); ?>" src="<?php echo wp_get_attachment_url($item['image_small_2']); ?>" alt="<?php the_title($item['image_small_2']); ?>"/>
											<?php if( ! empty( $item['image_small_2_link'] ) ) { ?> </a> <?php } ?>
										</div>
									<?php } ?>
								</div>
							<?php endif; ?>

							<div class="qodef-hli-mid <?php echo esc_attr( $item_classes ); ?>">
								<p class="qodef-hli-text">
									<?php if (!empty($item['text_link'])) { ?> <a href="<?php echo esc_url($item['text_link']); ?>" target="<?php echo esc_attr($item['text_target']); ?>"> <?php } ?>
										<?php echo esc_html($item['text']); ?>
									<?php if (!empty($item['text_link'])) { ?> </a> <?php } ?>
								</p>
								<h2 class="qodef-hli-title" <?php echo esc_attr( $animation_data ); ?>>
									<?php if (!empty($item['link'])) { ?> <a href="<?php echo esc_url($item['link']); ?>" target="<?php echo esc_attr($item['target']); ?>"> <?php } ?>
										<?php echo esc_html($item['title']); ?>
									<?php if (!empty($item['link'])) { ?> </a> <?php } ?>
								</h2>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endforeach; endif; ?>
	</div>
	<div class="qodef-hl-scroll-text">
		<a href="#"><?php echo esc_html__('Scroll to discover', 'stockholm-core'); ?></a>
		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="33" height="11" viewBox="0 0 33 11">
			<image id="Vector_Smart_Object2" data-name="Vector Smart Object2" width="33" height="11" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAACEAAAALCAYAAADx0+Q/AAAAeklEQVQ4jc3UsQ2CUBSF4R9ykgOdDMIYtk5iYWPCKIzhBNjJInYMYF5iIrEzSP3uOwv8X3FzyTXZreyH7H6brHMh3im9gBsw7UGyTvYgeykOItmHAMcINMBd9rGS/QlA/O4poAuKX4AzcAqphx9nCYBrNOD7Mec/ALACDsIV5l3DR00AAAAASUVORK5CYII="/>
		</svg>
	</div>
	<div id="qodef-hl-scroll-area"></div>
</div>
