<div class="wrap about-wrap qodef-core-dashboard">
    <h1 class="qodef-cd-title"><?php esc_html_e('Import', 'stockholm-core'); ?></h1>
    <h4 class="qodef-cd-subtitle"><?php esc_html_e('You can import the theme demo content here.', 'stockholm-core'); ?></h4>
    <div class="qodef-core-dashboard-inner">
        <div class="qodef-cd-demos-list qodef-cd-demos-masonry qodef-cd-demos-four-columns qodef-cd-medium-space">
            <?php echo stockholm_core_get_module_template_part('sub-pages/import/templates/filter', 'core-dashboard', '', $params); ?>
            <div class="qodef-cd-demos-list-inner">
                <div class="qodef-cd-grid-sizer"></div>
                <div class="qodef-cd-grid-gutter"></div>
                <?php foreach($demos_list as $demo_key => $demo) {
                    $item_category = array();
                    if(isset($demo['categories'])){
                        foreach ($demo['categories'] as $cat_key => $cat){
                            $item_category[] = 'demo-category-' . $cat_key;
                        }
                    }
					if( isset( $demo['should_render'] ) && $demo['should_render'] == false ) {
						continue;
					} else {
						$page_builders = array();

						if( is_array( $demo['required-plugins'] ) ) {
							if( in_array( 'js_composer', $demo['required-plugins'] ) ) {
								$page_builders[$demo_key] = esc_html__( 'WP Bakery', 'stockholm-core' );
							}
						}

						if( is_array( $demo['required-plugins'] ) ) {
							if( in_array( 'elementor', $demo['required-plugins'] ) ) {
								$page_builders[$demo_key] = esc_html__( 'Elementor', 'stockholm-core' );
							}
						}

						if( is_array( $demo['required-plugins'] ) ) {
							if( in_array( 'qi-blocks', $demo['required-plugins'] ) ) {
								$page_builders[$demo_key] = esc_html__( 'Gutenberg', 'stockholm-demos' );
							}
						}

						$related_demos = ! empty( $demo['related_demos'] ) ? $demo['related_demos'] : false;
						if( is_array( $related_demos ) && count( $related_demos ) > 0 ) {
							foreach( $related_demos as $related_demo_id => $related_demo_plugin ) {
								if( 'js_composer' === $related_demo_plugin ) {
									$page_builders[$related_demo_id] = esc_html__( 'WP Bakery', 'stockholm-demos' );
								}

								if( 'elementor' === $related_demo_plugin ) {
									$page_builders[$related_demo_id] = esc_html__( 'Elementor', 'stockholm-demos' );
								}

								if( 'qi-blocks' === $related_demo_plugin ) {
									$page_builders[$related_demo_id] = esc_html__( 'Gutenberg', 'stockholm-demos' );
								}
							}
						}

						?>
	                    <article class="qodef-cd-demo-item <?php echo implode(' ', $item_category); ?>">
	                        <div class="qodef-cd-demo-item-inner">
	                            <div class="qodef-cd-di-image">
	                                <img src="https://export.qodethemes.com/stockholm/stockholm-admin/images/demos/<?php echo esc_attr($demo_key); ?>.jpg" />
	                                <div class="qodef-cd-di-links-holder">
		                                <div class="qodef-cd-di-links-holder-inner">
		                                    <span class="qodef-cd-di-demo-links">
			                                    <?php foreach( $page_builders as $page_builder_demo_key => $page_builder_name ) { ?>
													<a href="#" class="qodef-cd-demo-item-link" data-demo-id="<?php echo esc_attr( $page_builder_demo_key ); ?>" data-original-demo-id="<?php echo esc_attr( $demo_key ); ?>"><?php echo esc_html( $page_builder_name ); ?></a>
			                                    <?php } ?>
		                                    </span>
		                                </div>
	                                </div>
	                            </div>
	                            <div class="qodef-cd-di-text">
	                                <h3 class="qodef-cd-di-title"><?php echo esc_attr($demo['title']); ?></h3>
	                                <?php if(!empty($demo['categories'])) { ?>
	                                    <div class="qodef-cd-di-categories">
	                                        <?php foreach ($demo['categories'] as $cat_key => $cat) { ?>
	                                            <span><?php echo esc_html($cat); ?></span>
	                                        <?php } ?>
	                                    </div>
	                                <?php } ?>
	                            </div>
	                        </div>
	                    </article>
					<?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
</div>