<?php

class StockholmCoreElementorLatestPosts extends \Elementor\Widget_Base{
    public function get_name() {
        return 'latest_posts';
    }

    public function get_title() {
        return esc_html__( "Latest Posts", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-latest-posts';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    $this->add_control(
		    'type',
		    [
			    'label' => esc_html__( "Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'image_in_box' => esc_html__( 'Image in left box', 'stockholm-core' ),
				    'boxes'        => esc_html__( 'Boxes', 'stockholm-core' )
			    ],
			    'default' => 'image_in_box'
		    ]
	    );

        $this->add_control(
            'number_of_posts',
            [
                'label' => esc_html__( "Number of Posts", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
	                'type' => 'image_in_box'
                ]
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => esc_html__( "Image Size", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'portfolio-default' => esc_html__('Predefined', 'stockholm-core'),
                    'full' => esc_html__('Full ( Original )', 'stockholm-core'),
                ],
                'default' => 'portfolio-default',
                'condition' => [
                    'type' => 'boxes'
                ]
            ]
        );

        $this->add_control(
            'number_of_columns',
            [
                'label' => esc_html__( "Number of Columns", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__( 'One', 'stockholm-core' ),
                    '2' => esc_html__( 'Two', 'stockholm-core' ),
                    '3' => esc_html__( 'Three', 'stockholm-core' ),
                    '4' => esc_html__( 'Four', 'stockholm-core' ),
                    '5' => esc_html__( 'Five', 'stockholm-core' ),
                ],
                'default' => '3',
                'condition' => [
	                'type' => 'boxes'
                ]
            ]
        );
	
	    $this->add_control(
		    'number_of_rows',
		    [
			    'label' => esc_html__( "Number of Rows", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    '1' => esc_html__( 'One', 'stockholm-core' ),
				    '2' => esc_html__( 'Two', 'stockholm-core' ),
				    '3' => esc_html__( 'Three', 'stockholm-core' ),
				    '4' => esc_html__( 'Four', 'stockholm-core' ),
				    '5' => esc_html__( 'Five', 'stockholm-core' ),
				    '6' => esc_html__( 'Six', 'stockholm-core' ),
			    ],
			    'default' => '1',
			    'condition' => [
				    'type' => 'boxes'
			    ]
		    ]
	    );

        $this->add_control(
            'order_by',
            [
                'label' => esc_html__( "Order By", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'title' => esc_html__( 'Title', 'stockholm-core' ),
                    'date'  => esc_html__( 'Date', 'stockholm-core' )
                ],
                'default' => 'title'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( "Order", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array(),
                'default' => 'ASC'
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => esc_html__( "Category Slug", 'stockholm-core' ),
                "description" => esc_html__( "Leave empty for all or use comma for list", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'text_length',
            [
                'label' => esc_html__( "Text Length", 'stockholm-core' ),
                "description" => esc_html__( "Number of characters", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '50',
                'condition' => [
	                'type' => 'boxes'
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(false),
                'default' => 'h4'
            ]
        );
	
	    $this->add_control(
		    'display_category',
		    [
			    'label' => esc_html__( "Display Category", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''   => esc_html__( 'Default', 'stockholm-core' ),
				    '1'  => esc_html__( 'Yes', 'stockholm-core' ),
				    '0'  => esc_html__( 'No', 'stockholm-core' ),
			    ],
			    'default' => ''
		    ]
	    );
	
	    $this->add_control(
		    'display_date',
		    [
			    'label' => esc_html__( "Display Date", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''   => esc_html__( 'Default', 'stockholm-core' ),
				    '1'  => esc_html__( 'Yes', 'stockholm-core' ),
				    '0'  => esc_html__( 'No', 'stockholm-core' ),
			    ],
			    'default' => ''
		    ]
	    );
	
	    $this->add_control(
		    'display_author',
		    [
			    'label' => esc_html__( "Display Author", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''   => esc_html__( 'Default', 'stockholm-core' ),
				    '1'  => esc_html__( 'Yes', 'stockholm-core' ),
				    '0'  => esc_html__( 'No', 'stockholm-core' ),
			    ],
			    'default' => ''
		    ]
	    );
	    
        $this->add_control(
            'background_color',
            [
                'label' => esc_html__( "Box Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
	                'type' => 'boxes'
                ]
            ]
        );

        $this->end_controls_section();

        // Add predefined developer tab content for each shortcode element
        $this->start_controls_section(
            'developer_tools',
            [
                'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode_snippet',
            [
                'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'no',
                'options' => stockholm_qode_get_yes_no_select_array()
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
            echo $this->get_shortcode_snippet( $params );
        } else{
            echo stockholm_qode_get_shortcode_template_part('templates/latest-posts', '_latest-posts', '', $params);
        }
    }

    private function get_shortcode_snippet( $params ) {
        $atts = array();

        if ( empty( $this ) || ! is_object( $this ) ) {
            return '';
        }

        if ( ! empty( $params ) ) {
            foreach ( $params as $key => $value ) {
                if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
                    continue;
                }

                if( empty( $value ) || $value == '' ){
                    continue;
                }

                $atts[] = $key . '="' . esc_attr( $value ) . '"';
            }
        }

        return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
            'latest_post',
            implode( ' ', $atts )
        );
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorLatestPosts() );