<?php

class StockholmCoreElementorLineGraph extends \Elementor\Widget_Base{
    public function get_name() {
        return 'line_graph';
    }

    public function get_title() {
        return esc_html__( "Line Graph", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-line-graph';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'type',
            [
                'label' => esc_html__( "Type", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => '',
                    'rounded' => esc_html__( 'Rounded edges', 'stockholm-core' ),
                    'sharp'   => esc_html__( 'Sharp edges', 'stockholm-core' ),
                ],
                'default' => 'rounded'
            ]
        );

        $this->add_control(
            'width',
            [
                'label' => esc_html__( "Width", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '750'
            ]
        );

        $this->add_control(
            'height',
            [
                'label' => esc_html__( "Height", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '350'
            ]
        );

        $this->add_control(
            'custom_color',
            [
                'label' => esc_html__( "Custom Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'scale_steps',
            [
                'label' => esc_html__( "Scale steps", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '6'
            ]
        );

        $this->add_control(
            'scale_step_width',
            [
                'label' => esc_html__( "Scale step width", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '20'
            ]
        );

        $this->add_control(
            'labels',
            [
                'label' => esc_html__( "Labels", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Label 1, Label 2, Label 3', 'stockholm-core' ),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( "Content", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( '#e6ae48,Legend One,1,5,10;#f5b94d,Legend Two,3,7,20;#fdc050,Legend Three,10,2,34', 'stockholm-core' )
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/line-graph', '_line-graph', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorLineGraph() );