<?php

class StockholmCoreElementorOrderedList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'ordered_list';
    }

    public function get_title() {
        return esc_html__( 'Ordered List', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-ordered-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

	    $this->add_control(
		    'content',
		    [
			    'label' => esc_html__( "Content", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::WYSIWYG,
			    'default' => '<ol><li>' . esc_html__( 'Lorem Ipsum', 'stockholm-core' ) . '</li><li>' . esc_html__( 'Lorem Ipsum', 'stockholm-core' ) . '</li><li>' . esc_html__( 'Lorem Ipsum', 'stockholm-core' ) . '</li></ol>'

		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/ordered-list', '_ordered-list', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorOrderedList() );