<?php

class StockholmCoreElementorPricingTables extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_pricing_tables';
    }

    public function get_title() {
        return esc_html__( 'Pricing Tables', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-pricing-tables';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'two_columns'   => esc_html__('Two', 'stockholm-core'),
                    'three_columns' => esc_html__('Three', 'stockholm-core'),
                    'four_columns'  => esc_html__('Four', 'stockholm-core'),
                ],
                'default' => 'four_columns'
            ]
        );

        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__("Basic Plan", "stockholm-core"),
            ]
        );

        $repeater->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );
	
	    $repeater->add_control(
		    'title_background_color',
		    [
			    'label' => esc_html__( 'Title Background Color', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::COLOR,
		    ]
	    );
	    
        $repeater->add_control(
            'price',
            [
                'label' => esc_html__( 'Price', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__( "Default value is 100", 'stockholm-core' ),
                'default' => '100'
            ]
        );
	
	    $repeater->add_control(
		    'price_font_weight',
		    [
			    'label' => esc_html__( 'Price Font Weight', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_font_weight_array(true),
			    'default' => '100'
		    ]
	    );

        $repeater->add_control(
            'currency',
            [
                'label' => esc_html__( 'Currency', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__( "Default mark is $", 'stockholm-core' ),
                'default' => esc_html__('$', 'stockholm-core')
            ]
        );

        $repeater->add_control(
            'price_period',
            [
                'label' => esc_html__( 'Price Period', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__( "Default label is monthly", 'stockholm-core' ),
                'default' => '/mo'
            ]
        );
        
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Button Link', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'button_text!' => ''
                ]
            ]
        );

        $repeater->add_control(
            'target',
            [
                'label' => esc_html__( 'Button Target', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_link_target_array(true),
                'condition' => [
                    'link!' => ''
                ],
                'default' => '_self'
            ]
        );
	
	
	    $repeater->add_control(
		    'button_color',
		    [
			    'label' => esc_html__( 'Button Color', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'button_text!' => ''
			    ]
		    ]
	    );
	
	    $repeater->add_control(
		    'button_background_color',
		    [
			    'label' => esc_html__( 'Button Background Color', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'button_text!' => ''
			    ]
		    ]
	    );
	
	    $repeater->add_control(
		    'content_background_color',
		    [
			    'label' => esc_html__( 'Content Background Color', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	    
        $repeater->add_control(
            'active',
            [
                'label' => esc_html__( 'Active', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false,false),
                'default' => 'no'
            ]
        );

        $repeater->add_control(
            'active_text',
            [
                'label' => esc_html__( 'Active text', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'active' => 'yes'
                ],
                'default' => esc_html__('Best choice', 'stockholm-core')
            ]
        );
	
	    $repeater->add_control(
		    'active_text_color',
		    [
			    'label' => esc_html__( 'Active Text Color', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
		            'active' => 'yes'
			    ]
		    ]
	    );
	
	    $repeater->add_control(
		    'active_text_background_color',
		    [
			    'label' => esc_html__( 'Active Text Background Color', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'active' => 'yes'
			    ]
		    ]
	    );

        $repeater->add_control(
            'content',
            [
                'label' => esc_html__( 'Content', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => "<li>" . esc_html__('content content content', 'stockholm-core') . "</li><li>" . esc_html__('content content content', 'stockholm-core') . "</li><li>" . esc_html__('content content content', 'stockholm-core') . "</li>"
            ]
        );

        $this->add_control(
            'pricing_tables',
            [
                'label' => esc_html__( 'Pricing Table', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls()
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        ?>

        <div class="qode_pricing_tables clearfix <?php echo esc_attr( $params['columns'] ); ?>">

        <?php
	        foreach ($params['pricing_tables'] as $pricing_table){
	            echo stockholm_qode_get_shortcode_template_part('templates/pricing-table', '_pricing-tables', '', $pricing_table);
	        }
        ?>

        </div>

        <?php

    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorPricingTables() );