<?php

class StockholmCoreElementorProgressBarVertical extends \Elementor\Widget_Base{
    public function get_name() {
        return 'progress_bar_vertical';
    }

    public function get_title() {
        return esc_html__( 'Progress Bar Vertical', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-progress-bar-vertical';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( 'Title Tag', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_title_tag( false ),
				'default' => 'h5'
			]
		);

		$this->add_control(
			'title_size',
			[
				'label' => esc_html__( 'Title Size (px)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'bar_color',
			[
				'label' => esc_html__( 'Bar Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'bar_border_color',
			[
				'label' => esc_html__( 'Bar Border Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__( 'Top Border Radius', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'percent',
			[
				'label' => esc_html__( 'Percent', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100'
			]
		);
	
	    $this->add_control(
		    'show_percent_mark',
		    [
			    'label' => esc_html__( 'Show Percentage Mark', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    "with_mark"    => esc_html__( "Yes", 'stockholm' ),
				    "without_mark" => esc_html__( "No", 'stockholm' )
			    ],
			    'default' => '',
			    'condition' => [
				    'percent!' => ''
			    ]
		    ]
	    );

		$this->add_control(
			'percentage_text_size',
			[
				'label' => esc_html__( 'Percentage Text Size(px)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'percent!' => ''
				]
			]
		);

		$this->add_control(
			'percent_color',
			[
				'label' => esc_html__( 'Percentage Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'percent!' => ''
				]
			]
		);

		$this->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA
			]
		);
		
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/progress-bar-vertical', '_progress-bar-vertical', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorProgressBarVertical() );