<?php

class StockholmCoreElementorSocialShareList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'social_share_list';
    }

    public function get_title() {
        return esc_html__( 'Social Share List', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-social-share-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {
	
	    $this->start_controls_section(
		    'general',
		    [
			    'label' => esc_html__( 'General', 'stockholm-core' ),
			    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		    ]
	    );
	    
	    $this->add_control(
		    'list_type',
		    [
			    'label' => esc_html__( 'Icon Type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'circle'	    => esc_html__( 'Circle', 'stockholm-core' ),
				    'regular'	    => esc_html__( 'Regular', 'stockholm-core' )
			    ),
			    'default' => 'regular',
		    ]
	    );
	
	    $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/social-share-list', '_social-share-list', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorSocialShareList() );