<?php

class StockholmCoreElementorTeam extends \Elementor\Widget_Base{
    public function get_name() {
        return 'team';
    }

    public function get_title() {
        return esc_html__( 'Team', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-team';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

		$social_icons_array = array(
			"" => "",
			"ADN" => "fa-adn",
			"Android" => "fa-android",
			"Apple" => "fa-apple",
			"Bitbucket" => "fa-bitbucket",
			"Bitbucket-Sign" => "fa-bitbucket-sign",
			"Bitcoin" => "fa-bitcoin",
			"BTC" => "fa-btc",
			"CSS3" => "fa-css3",
			"Dribbble" => "fa-dribbble",
			"Dropbox" => "fa-dropbox",
			"E-mail" => "fa-envelope",
			"Facebook" => "fa-facebook",
			"Facebook-Sign" => "fa-facebook-sign",
			"Flickr" => "fa-flickr",
			"Foursquare" => "fa-foursquare",
			"GitHub" => "fa-github",
			"GitHub-Alt" => "fa-github-alt",
			"GitHub-Sign" => "fa-github-sign",
			"Gittip" => "fa-gittip",
			"Google Plus" => "fa-google-plus",
			"Google Plus-Sign" => "fa-google-plus-sign",
			"HTML5" => "fa-html5",
			"Instagram" => "fa-instagram",
			"LinkedIn" => "fa-linkedin",
			"LinkedIn-Sign" => "fa-linkedin-sign",
			"Linux" => "fa-linux",
			"Mail" => "fa-envelope",
			"Mail Alt" => "fa-envelope-o",
			"Mail Square" => "fa-envelope-square",
			"MaxCDN" => "fa-maxcdn",
			"Pinterest" => "fa-pinterest",
			"Pinterest-Sign" => "fa-pinterest-sign",
			"Renren" => "fa-renren",
			"Skype" => "fa-skype",
			"StackExchange" => "fa-stackexchange",
			"Trello" => "fa-trello",
			"Tumblr" => "fa-tumblr",
			"Tumblr-Sign" => "fa-tumblr-sign",
			"Twitter" => "fa-twitter",
			"Twitter-Sign" => "fa-twitter-sign",
			"Vimeo-Square" => "fa-vimeo-square",
			"VK" => "fa-vk",
			"Weibo" => "fa-weibo",
			"Windows" => "fa-windows",
			"Xing" => "fa-xing",
			"Xing-Sign" => "fa-xing-sign",
			"YouTube" => "fa-youtube",
			"YouTube Play" => "fa-youtube-play",
			"YouTube-Sign" => "fa-youtube-sign"
		);

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

	    $this->add_control(
		    'team_type',
		    [
			    'label' => esc_html__( 'Type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    ''				=> esc_html__( 'Default', 'stockholm-core' ),
				    'info_hover'    => esc_html__( 'Info on Hover', 'stockholm-core' ),
			    ),
				'default' => ''
		    ]
	    );

	    $this->add_control(
		    'icons_position',
		    [
			    'label' => esc_html__( 'Social Icons Position', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    ''				=> esc_html__( 'Default ( On Hover )', 'stockholm-core' ),
				    'below_title'    => esc_html__( 'Below Title', 'stockholm-core' ),
			    ),
				'default' => '',
                'condition' => [
                    'team_type' => ''
                ]
		    ]
	    );

	    $this->add_control(
		    'team_image',
		    [
			    'label' => esc_html__( 'Image', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::MEDIA
		    ]
	    );
	
	    $this->add_control(
		    'team_image_hover_color',
		    [
			    'label' => esc_html__( 'Image Hover Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'team_name',
		    [
			    'label' => esc_html__( 'Name', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	
	    $this->add_control(
		    'team_name_tag',
		    [
			    'label'		=> esc_html__( 'Name Tag', 'stockholm-core' ),
			    'type'		=> \Elementor\Controls_Manager::SELECT,
			    'options'	=> stockholm_qode_get_title_tag( true ),
			    'default'	=> 'h3',
			    'condition' => [
				    'team_name!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_name_font_size',
		    [
			    'label' => esc_html__( 'Name Font Size(px', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'team_name!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_name_color',
		    [
			    'label' => esc_html__( 'Name Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_name!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_name_font_weight',
		    [
			    'label'		=> esc_html__( 'Name Font Weight', 'stockholm-core' ),
			    'type'		=> \Elementor\Controls_Manager::SELECT,
			    'options'	=> stockholm_qode_get_font_weight_array( true ),
			    'condition' => [
				    'team_name!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_name_text_transform',
		    [
			    'label'		=> esc_html__( 'Name Text Transform', 'stockholm-core' ),
			    'type'		=> \Elementor\Controls_Manager::SELECT,
			    'options'	=> stockholm_qode_get_text_transform_array( true ),
			    'condition' => [
				    'team_name!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_position',
		    [
			    'label' => esc_html__( 'Position', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	
	    $this->add_control(
		    'team_position_font_size',
		    [
			    'label' => esc_html__( 'Position Font Size(px)', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'team_position!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_position_color',
		    [
			    'label' => esc_html__( 'Position Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_position!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_position_font_weight',
		    [
			    'label'		=> esc_html__( 'Position Font Weight', 'stockholm-core' ),
			    'type'		=> \Elementor\Controls_Manager::SELECT,
			    'options'	=> stockholm_qode_get_font_weight_array( true ),
			    'condition' => [
				    'team_position!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_position_text_transform',
		    [
			    'label'		=> esc_html__( 'Position Text Transform', 'stockholm-core' ),
			    'type'		=> \Elementor\Controls_Manager::SELECT,
			    'options'	=> stockholm_qode_get_text_transform_array( true ),
			    'condition' => [
				    'team_position!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_description',
		    [
			    'label' => esc_html__( 'Description', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXTAREA
		    ]
	    );
	
	    $this->add_control(
		    'team_description_color',
		    [
			    'label' => esc_html__( 'Description Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_description!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'text_align',
		    [
			    'label' => esc_html__( 'Text Align', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    ''				  => esc_html__( 'Default', 'stockholm-core' ),
				    'left_align'      => esc_html__( 'Left', 'stockholm-core' ),
				    'center_align'    => esc_html__( 'Center', 'stockholm-core' ),
				    'right_align'     => esc_html__( 'Right', 'stockholm-core' )
			    ),
			    'default' => ''
		    ]
	    );
	
	    $this->add_control(
		    'background_color',
		    [
			    'label' => esc_html__( 'Background Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'box_border',
		    [
			    'label'		=> esc_html__( 'Box Border', 'stockholm-core' ),
			    'type'		=> \Elementor\Controls_Manager::SELECT,
			    'options'	=> stockholm_qode_get_yes_no_select_array(true),
			    'default'	=> ''
		    ]
	    );
	
	    $this->add_control(
		    'box_border_width',
		    [
			    'label' => esc_html__( 'Box Border Width', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'box_border' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'box_border_color',
		    [
			    'label' => esc_html__( 'Box Border Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'box_border' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_social_icon_pack',
		    [
			    'label' => esc_html__( 'Social Icon Pack', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'font_awesome'	=> esc_html__( 'Font Awesome', 'stockholm-core' ),
				    'font_elegant'	=> esc_html__( 'Font Elegant', 'stockholm-core' )
			    )
		    ]
	    );
	    
	    $this->add_control(
		    'team_social_icon_type',
		    [
			    'label' => esc_html__( 'Type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'normal_social'	=> esc_html__( 'Normal', 'stockholm-core' ),
				    'circle_social'	=> esc_html__( 'Circle', 'stockholm-core' ),
				    'square_social'	=> esc_html__( 'Square', 'stockholm-core' )
			    ),
			    'default' => 'normal_social'
		    ]
	    );
	
	    $this->add_control(
		    'team_social_icon_color',
		    [
			    'label' => esc_html__( 'Social Icons Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'team_social_icon_background_color',
		    [
			    'label' => esc_html__( 'Social Icons Background Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_social_icon_type' => array( 'circle_social', 'square_social' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_social_icon_border_color',
		    [
			    'label' => esc_html__( 'Social Icons Border Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_social_icon_type' => array( 'circle_social', 'square_social' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_social_icon_hover_color',
		    [
			    'label' => esc_html__( 'Social Icons Hover Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'team_social_background_hover_color',
		    [
			    'label' => esc_html__( 'Social Icons Background Hover Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_social_icon_type' => array( 'circle_social', 'square_social' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'team_social_border_hover_color',
		    [
			    'label' => esc_html__( 'Social Icons Border Hover Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'team_social_icon_type' => array( 'circle_social', 'square_social' )
			    ]
		    ]
	    );
	    
		for($i = 1 ; $i<= 5; $i++) {

			$this->add_control(
				'team_social_fa_icon_' . $i,
				[
					'label' => esc_html__('Social Icon ', 'stockholm-core') . ' ' . $i,
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => stockholm_qode_font_awesome_social(),
					'default' => '',
					'condition' => [
						'team_social_icon_pack' => 'font_awesome'
					]
				]
			);
			
			$this->add_control(
				'team_social_fe_icon_' . $i,
				[
					'label' => esc_html__('Social Icons ', 'stockholm-core') . ' ' . $i,
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => stockholm_qode_font_elegant_social(),
					'default' => '',
					'condition' => [
						'team_social_icon_pack' => 'font_elegant'
					]
				]
			);
			
			$this->add_control(
				'team_social_icon_'. $i . '_link',
				[
					'label' => esc_html__('Social Icon', 'stockholm-core') . ' ' . $i . ' ' . esc_html__('Link', 'stockholm-core'),
					'type' => \Elementor\Controls_Manager::TEXT
				]
			);

			$this->add_control(
				'team_social_icon_'. $i . '_target',
				[
					'label' => esc_html__('Social Icon', 'stockholm-core') . ' ' . $i. ' ' . esc_html__('Target', 'stockholm-core'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => stockholm_qode_get_link_target_array(true),
					'default' => ''
				]
			);
		}
	
	    $this->add_control(
		    'show_skills',
		    [
			    'label' => esc_html__( 'Team Member Skills', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SWITCHER
		    ]
	    );
	
	    $this->add_control(
		    'skills_title_size',
		    [
			    'label' => esc_html__( 'Skills Title Size', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'skill_title_1',
		    [
			    'label' => esc_html__( 'First Skill Title', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'skill_percentage_1',
		    [
			    'label' => esc_html__( 'First Skill Percentage', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( "Enter just number, without %", 'stockholm-core' ),
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'skill_title_2',
		    [
			    'label' => esc_html__( 'Second Skill Title', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'skill_percentage_2',
		    [
			    'label' => esc_html__( 'Second Skill Percentage', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( "Enter just number, without %", 'stockholm-core' ),
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'skill_title_3',
		    [
			    'label' => esc_html__( 'Third Skill Title', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'skill_percentage_3',
		    [
			    'label' => esc_html__( 'Third Skill Percentage', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( "Enter just number, without %", 'stockholm-core' ),
			    'condition' => [
				    'show_skills' => 'yes'
			    ]
		    ]
	    );
		
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

		if( ! empty( $params['team_image'] ) ){
			$params['team_image'] = $params['team_image']['id'];
		}

        echo stockholm_qode_get_shortcode_template_part('templates/team', '_team', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorTeam() );