<?php

class StockholmCoreElementorTestimonials extends \Elementor\Widget_Base{
    public function get_name() {
        return 'testimonials';
    }

    public function get_title() {
        return esc_html__( 'Testimonials', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-testimonials';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    $this->add_control(
		    'type',
		    [
			    'label' => esc_html__( 'Type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    ''          => esc_html__( 'Default', 'stockholm-core' ),
				    'grouped'   => esc_html__( 'Grouped', 'stockholm-core' )
			    ),
			    'default' => ''
		    ]
	    );

	    $this->add_control(
		    'category',
		    [
			    'label' => esc_html__( 'Category', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'description' => esc_html__('Category Slug (leave empty for all)', 'stockholm-core')
		    ]
	    );

	    $this->add_control(
		    'number',
		    [
			    'label' => esc_html__( 'Number', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'description' => esc_html__('Number of Testimonials', 'stockholm-core')
		    ]
	    );
	
	    $this->add_control(
		    'show_author_image',
		    [
			    'label' => esc_html__( 'Show Author Image', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array()
		    ]
	    );
	
	    $this->add_control(
		    'show_title',
		    [
			    'label' => esc_html__( 'Show Title', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(),
			    'condition' => [
				    'type' => ''
			    ],
		    ]
	    );
	
	    $this->add_control(
		    'text_color',
		    [
			    'label' => esc_html__( 'Text Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'text_font_size',
		    [
			    'label' => esc_html__( 'Text Font Size', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	
	    $this->add_control(
		    'author_text_color',
		    [
			    'label' => esc_html__( 'Author Text Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'show_author_job_position',
		    [
			    'label' => esc_html__( 'Show Author Job Position', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false),
				'default' => 'no'
		    ]
	    );
	
	    $this->add_control(
		    'text_align',
		    [
			    'label' => esc_html__( 'Text Align', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'left_align'      => esc_html__( 'Left', 'stockholm-core' ),
				    'center_align'    => esc_html__( 'Center', 'stockholm-core' ),
				    'right_align'     => esc_html__( 'Right', 'stockholm-core' )
			    ),
			    'default' => 'left_align'
		    ]
	    );
	
	    $this->add_control(
		    'show_navigation',
		    [
			    'label' => esc_html__( 'Show navigation', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false, true),
			    'default' => 'yes'
		    ]
	    );
	
	    $this->add_control(
		    'navigation_style',
		    [
			    'label' => esc_html__( 'Navigation Style', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'dark'   => esc_html__( 'Dark', 'stockholm-core' ),
				    'light'  => esc_html__( 'Light', 'stockholm-core' )
			    ),
			    'condition' => [
				    'show_navigation' => 'yes'
			    ],
			    'default' => 'dark'
		    ]
	    );

		$this->add_control(
			'show_navigation_arrows',
			[
				'label' => esc_html__( 'Show navigation arrows', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array(false, false),
				'default' => 'no'
			]
		);

	    $this->add_control(
		    'auto_rotate_slides',
		    [
			    'label' => esc_html__( 'Auto rotate slides', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				   '3'  => esc_html__( '3', 'stockholm-core' ),
				   '5'  => esc_html__( '5', 'stockholm-core' ),
				   '10' => esc_html__( '10', 'stockholm-core' ),
				   '15' => esc_html__( '15', 'stockholm-core' ),
				   '0'  => esc_html__( 'Disable', 'stockholm-core' )
			    ),
			    'default' => '3'
		    ]
	    );

	    $this->add_control(
		    'animation_type',
		    [
			    'label' => esc_html__( 'Animation type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				   'fade'    => esc_html__( 'Fade', 'stockholm-core' ),
				   'slide'   => esc_html__( 'Slide', 'stockholm-core' )
			    ),
			    'default' => 'fade'
		    ]
	    );

	    $this->add_control(
		    'animation_speed',
		    [
			    'label' => esc_html__( 'Animation speed', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'description' => esc_html__( 'Speed of slide animation in miliseconds', 'stockholm-core' )
		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/testimonials', '_testimonials', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorTestimonials() );