<?php

if( stockholm_qode_is_contact_form_7_installed('contact-form-7') ){
    class StockholmCoreContactForm7 extends \Elementor\Widget_Base{
        public function get_name() {
            return 'stockholm_cf_7';
        }

        public function get_title() {
            return esc_html__( 'Contact Form 7', 'stockholm-core' );
        }

        public function get_icon() {
            return 'stockholm-elementor-custom-icon stockholm-elementor-contact-form-7';
        }

        public function get_categories() {
            return [ 'qode' ];
        }

        protected function register_controls(){
            $this->start_controls_section(
                'general',
                [
                    'label' => esc_html__( 'General', 'stockholm-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $this->add_control(
                'cf7',
                [
                    'label' => esc_html__( 'Select Contact Form', 'void' ),
                    'description' => esc_html__('You need to install and activate Contact Form 7 plugin','stockholm-core'),
                    'type' => \Elementor\Controls_Manager::SELECT2,
                    'multiple' => false,
                    'label_block' => 1,
                    'options' => $this->get_contact_form_7_posts(),
                ]
            );

            $this->add_control(
                'html_class',
                [
                    'label' => esc_html__( 'Select Contact Form Style', 'void' ),
                    'description' => esc_html__('Contact form 7 - plugin must be installed and there must be some contact forms made with the contact form 7','void'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'default' => esc_html__('Default', 'stockholm-core'),
                        'cf7_custom_style_1' => esc_html__('Custom Style 1', 'stockholm-core'),
                        'cf7_custom_style_2' => esc_html__('Custom Style 2', 'stockholm-core')],
                ]
            );

            $this->end_controls_section();

            // Add predefined developer tab content for each shortcode element
            $this->start_controls_section(
                'developer_tools',
                [
                    'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $this->add_control(
                'shortcode_snippet',
                [
                    'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'default' => 'no',
                    'options' => stockholm_qode_get_yes_no_select_array()
                ]
            );

            $this->end_controls_section();

        }

        protected function render(){
            static $counter = 0;

            $params = $this->get_settings_for_display();
            $params['counter'] = $counter;

            if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
                echo $this->get_shortcode_snippet( $params );
            } else{
                echo stockholm_qode_get_shortcode_template_part('templates/contact-form-7', 'contact-form-7', '', $params);
            }

            $counter++;
        }

        protected function get_contact_form_7_posts(){
            $args = array(
                'post_type' => 'wpcf7_contact_form',
                'posts_per_page' => -1
            );

            $category_list = [];

            if ($categories = get_posts($args)) {
                foreach ($categories as $category) {
                    (int)$category_list[$category->ID] = $category->post_title;
                }
            } else {
                (int)$category_list['0'] = esc_html__('No contect From 7 form found', 'void');
            }
            return $category_list;
        }

        private function get_shortcode_snippet( $params ) {
            $atts = array();

            if ( empty( $this ) || ! is_object( $this ) ) {
                return '';
            }

            if ( ! empty( $params ) ) {
                foreach ( $params as $key => $value ) {
                    if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
                        continue;
                    }

                    if( empty( $value ) || $value == '' ){
                        continue;
                    }

                    //get proper param_name since we are here using real cf7 shortcode to be executed
                    if( $key == 'cf7' ) {
                        $key = 'id';
                    }

                    $atts[] = $key . '="' . esc_attr( $value ) . '"';
                }
            }

            return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
                'contact-form-7',
                implode( ' ', $atts )
            );
        }
    }

    \Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreContactForm7() );
}