(function ($) {
	'use strict';

	var horizontalLayout = {};
	qode.modules.horizontalLayout = horizontalLayout;

	horizontalLayout.qodeOnWindowLoad = qodeOnWindowLoad;

	$(window).on('load', qodeOnWindowLoad);

	/*
	 ** All functions to be called on $(window).load() should be in this function
	 */
	function qodeOnWindowLoad() {
		qodefHorizontalLayout().init();
		qodefScrollRight.init();
		qodeInitElementorHorizontalLayout();
	}

	var qodefScrollRight = {
		init: function () {
			this.holder = $('.qodef-scroll-right');

			if (this.holder.length) {
				// Scroll To Top
				this.holder.on('click', function (e) {
					e.preventDefault();
				});

				$("#qodef-scroll-right").addClass('qodef--appeared');
				qodefScrollRight.showHideScrollDown();
				qodefScrollRight.progressChart();
			}
		},
		progressChart: function () {
			var progressPath = document.querySelector('.qodef-scroll-right a .qodef-progress-circle path');
			var pathLength = progressPath.getTotalLength();
			progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
			progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
			progressPath.style.strokeDashoffset = pathLength;
			progressPath.getBoundingClientRect();
			progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
			var updateProgress = function () {
				var scroll = $(window).scrollTop();
				var height = $(document).height() - $(window).height();
				var progress = pathLength - (scroll * pathLength / height);
				progressPath.style.strokeDashoffset = progress;
			}

			$(window).scroll(function () {
				updateProgress();
			});
		},
		showHideScrollDown: function () {
			$(window).scroll(function () {
				var $thisItem = $(this),
					b = $thisItem.scrollTop(),
					c = $thisItem.height(),
					d,
					hitBottom = false;

				if (b > 0) {
					d = b + c / 2;
				} else {
					d = 1;
				}

				/* if scrolled to bottom */
				/*if( $(window).scrollTop() + $(window).height() == $(document).height()) {real bottom
				 hitBottom = true;
				 }*/

				if ($(window).scrollTop() > 0) {
					hitBottom = true;
				}

				if (hitBottom) {
					qodefScrollRight.addClass('off');
				} else {
					qodefScrollRight.addClass('on');
				}
			});
		},
		addClass: function (a) {
			this.holder.removeClass('qodef--off qodef--on');

			if (a === 'on') {
				this.holder.addClass('qodef--on');
			} else {
				this.holder.addClass('qodef--off');
			}
		}
	};

	/**
	 * Init Horizontal Layout Shortcode
	 */
	function qodefHorizontalLayout() {
		var $wrapper = $('.qodef-hl-items-wrapper'),
			$holder = $('#qodef-horizontal-layout'),
			$items = $('.qodef-hl-item'),
			$scrollArea = $('#qodef-hl-scroll-area'),
			$tops = $('.qodef-hli-top'),
			$mids = $('.qodef-hli-mid'),
			$btms = $('.qodef-hli-btm'),
			$intro = $('.qodef-hl-intro'),
			$cta = $('.qodef-hl-cta'),
			$hiddenItems = $('.qodef--has-horizontal-appear'),
			$parallaxImage = $('.qodef-hli-btm-bg-image-inner img'),
			$scrollTextHolder = $('.qodef-hl-scroll-text'),
			numOfItems = $items.length,
			btmOffset = 0,
			reverted = false,
			introW,
			speed = 200; //vh per item

		var c, w, offset, wrapperW,
			sX = 0,
			dX = 0;

		//trigger calculations
		var calc = function () {
			reset();
			setVars();
			setBottom();
			setX();
			setPositions();
		}

		//variables for calculation
		var setVars = function () {

			/* vertical header check */
			if ($('.qodef-header--vertical-sliding #qodef-page-header').length && window.innerWidth > 1024) {
				c = $('.qodef-header--vertical-sliding #qodef-page-header').width();
			} else if ($('.qodef-header--vertical #qodef-page-header').length && window.innerWidth > 1024) {
				c = $('.qodef-header--vertical #qodef-page-header').width();
			} else {
				c = 0;
			}
			w = window.innerWidth > 1024 ? window.innerWidth / 0.89342723 : window.innerWidth;
			offset = window.innerWidth > 1024 ? window.innerWidth / 0.89342723 : window.innerWidth;
			//intro offset offset = window.innerWidth > 1024 ? window.innerWidth / 2.59459459 : window.innerWidth;
			introW = $intro.outerWidth();
			wrapperW = (numOfItems - 1) * w + offset + introW;
		}

		//position bottom media element below the longest text el.
		var setBottom = function () {
			btmOffset = 0;

			$mids.each(function () {
				if ($(this).outerHeight(true) > btmOffset) btmOffset = $(this).outerHeight(true);
			})

			// image height ~51vh
			//$btms.height((1 - (btmOffset + $tops.first().height()) / window.innerHeight) * 100 + 'vh')
		}

		//calc next x value based on scroll position
		var setX = function () {
			sX = 1 - ($scroll) / (parseFloat($scrollArea.height()) - screen.height);
		}

		//position items incrementally to the right
		var setPositions = function () {
			$items.each(function (i) {
				$(this).css('right', (numOfItems - i - 1) * w);
			});
			$intro.css('right', (numOfItems) * w);
		}

		var val;

		//animate rAF
		var animate = function ($active) {
			reverted = false;
			/*reverted = true;*/
			val = Math.min(parseFloat((1 - ($active.offset().left - c) / (offset - c)).toFixed(4)), 1); //0-1

			//prev
			$active.prevAll('.qodef-hl-item').css({
				'transform': 'translate3d(-' + (offset - w) * val + 'px, 0, 0)',
				'width': offset + 'px'
			});
			$active.prevAll().find('.qodef-hli-btm-inner').height('100%');
			//active
			$active.css({
				'transform': 'translate3d(0, 0, 0)',
				'width': w + (offset - w) * val + 'px'
			});
			//$active.find('.qodef-hli-btm-inner').height(Math.min(Math.max((50 + val * 50), 50), 100) + '%');
			//next
			$active.next('.qodef-hl-item').css({
				'transform': 'translate3d(0, 0, 0)',
				'width': w + 'px'
			});
		}

		//reset values
		var reset = function () {
			reverted = true;

			$items.css('transform', 'translate3d(0, 0, 0)');
			$items.not(':first-child').width(w);
			$intro.css('transform', 'translate3d(0, 0, 0)');
			$intro.width(introW);
			//$items.not(':first-child').find('.qodef-hli-btm-inner').height('50%');
		}

		//set active item if in between 0 and offset values
		var setActive = function () {
			var $active = $items.not(':first-child').filter(function () {
				var $item = $(this);

				return $item.offset().left <= offset && $item.offset().left > 0;
			})

			$active.length && animate($active.first());
		}

		var setVisibleClass = function () {

			$hiddenItems.each(function () {
				var item = $(this);

				if ($window_width - c + 100> item.offset().left || item.offset().left <= 0) {
					item.not('.qodef-appeared').addClass('qodef--appeared');
				}
			});

			if( $scroll > 250 ){
				$scrollTextHolder.addClass('qodef-hidden');
			} else{
				$scrollTextHolder.removeClass('qodef-hidden');
			}
		}

		var setVisibleClassPhone = function () {

			$hiddenItems.each(function () {
				var item = $(this);

				item.appear(function () {
					item.addClass('qodef--appeared ');
				}, { accX: 0, accY: -50 });
			});
		}

		//60fps render
		var render = function () {
			/*dX = lerp(dX, sX, 0.1);*/
			dX = lerp(sX, dX, .1);
			dX = Math.max(dX, 0);
			if (window.innerWidth >= 1024) dX = parseFloat(dX.toFixed(4));

			$wrapper.css('transform', 'translate3d(' + dX * (wrapperW - window.innerWidth + c) + 'px, 0, 0)');

			setActive();
			!reverted && $scroll == 0 && reset();

			requestAnimationFrame(render);
		}

		var parallaxBackground = function () {
			$parallaxImage.each(function () {
				var $thisItem = $(this),
					thisItemLeft = $thisItem.offset().left,
					thisItemWidth = $thisItem.outerWidth(),
					thisItemRight = thisItemLeft + thisItemWidth,
					progressVal = 0,
					modifier = 'translateX',
					modifierUnit = 'px',
					startValue = 0,
					endValue = 0;

				// Set init value
				$thisItem.waitForImages(function () {
					$thisItem.css('transform', modifier + '(' + startValue + modifierUnit + ')');
				});

				var renderParallax = function ($item) {
					if ($item.length){
						$item.css('transform', modifier + '(' + (endValue + (1 - (progressVal * 1) * 1) * Math.abs(1 - startValue)) + modifierUnit + ')');
					}
					requestAnimationFrame(renderParallax);
				}

				$(window).on('scroll', function () {
					if ($scroll + window.innerWidth > thisItemLeft) {
						progressVal = Math.abs($scroll + window.innerWidth - thisItemRight) / window.innerWidth;
						if (progressVal < 1) {
							$thisItem.css('transform', modifier + '(' + (endValue + (1 - (progressVal * 1) * 1) * Math.abs(1 - startValue)) + modifierUnit + ')');
						}
					}
				});
			});
		}

		//linear interpolation
		var lerp = function (a, b, n) {
			return (1 - n) * a + n * b;
		}

		var videoSize = function () {
			var smallImage = document.querySelector('.qodef-hli-btm-img-1'),
				smallVideo = $holder.find('.qodef-m-video');

			if (smallImage !== null && smallVideo.length) {
				var smallImageWidth = smallImage.getBoundingClientRect().width,
					smallImageHeight = smallImage.getBoundingClientRect().height;

				smallVideo.each(function () {
					$(this).css({ 'width': smallImageWidth + 'px', 'height': smallImageHeight + 'px' });
				});
			}
		}

		var init = function () {
			qode_htmlEl.addClass('qodef-with-horizontal-layout-html');
			qode_body.addClass('qodef-with-horizontal-layout');

			videoSize();

			$(window).resize(function () {
				videoSize();
			});

			if (window.innerWidth > 1024) {
				calc();
				$scrollArea.height(numOfItems * speed + 'vh');

				if ( qode_htmlEl.hasClass('touchevents') ) {
					window.addEventListener("touchmove", setX);
				} else {
					window.addEventListener('scroll', setX);
				}

				//resize debounce
				var resizeTimer;
				window.addEventListener('resize', function () {
					clearTimeout(resizeTimer);
					resizeTimer = setTimeout(function () {
						calc();
					}, 250);

				});

				requestAnimationFrame(render);

				setTimeout(function () {
					setVisibleClass();
				}, 100);

				setTimeout(function () {
					parallaxBackground();
				}, 200);

				$(window).scroll(function () {
					setVisibleClass();
				});
			} else {
				setVisibleClassPhone();
			}
		}

		return {
			init: function () {
				$wrapper.length && init();

				setTimeout(function () {
					$holder.addClass('qodef-appear');
				}, 100);
			},
		}
	}

	function qodeInitElementorHorizontalLayout(){
		$j(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/qode_horizontal_layout.default', function() {
				qodefHorizontalLayout().init();
			} );
		});
	}
})(jQuery);
